/*------------------------------------------------------------------------------*
 * File Name: GetNDlg.h															*
 * Creation: CPY 1/15/2004														*
 * Purpose: Origin C for GetNBox's TreeEditControl to be used in any dialog		*
 * Copyright (c) OriginLab Corp.2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 9/19/04 GETN_MODELESS_DLG												*
 *	CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX							*
 *  DG 3/17/05 v8.0204 SUPPORT_GETN_BOX_GRIDVIEW								*
 *  DG 3/30/05 v8.0212 SUPPORT_MAX_HEIGHT_WIDTH_SETTING							*
 *  DG 4/27/05 QA70-7631 v8.0227 FIT_SIZE_WHEN_LIST_CHANGED						*
 *  SY 8/17/05 QA70-8027 v8.0290 IMPORT_WIZARD_XF								*
 *	CPY 6/10/2008 REMOVE_GETN_NEXT_PREV_DLG, as part of finding freeze in Origin start reported by Additive
 *			from looking at log, Marko found the problem is in linking inside void GetNPrevNextDlg::resizeDialog(uint* pIntIDs)
 *
 *------------------------------------------------------------------------------*/

#ifndef _GETN_DLG_H
#define _GETN_DLG_H

#ifdef _OLD_GETN_BOX_CODE //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

	
/// Iris 9/15/04 MOVE_DECLARATION_TO_HEADER
class GetNBoxDlg : public TreeEditDlg
{
private:
	//Tree		m_paramTree;
	TreeNode	m_input_tr; //CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
	PAPPLY_FUNC m_pApplyFunc;
	PEVENT_FUNC m_pEventFunc;
	bool		m_bUseTryForApply;//CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE

	bool		m_bApply1stTime;
	string		m_strTitle;
	string		m_strDescription;
	//
	string		m_strCuveNode;
	string		m_strClassName;
	
	string		m_strMaxHeightWidth;	///DG SUPPORT_MAX_HEIGHT_WIDTH_SETTING : separate with '|'
	
	//RangeControl m_dataRange;
	
	Button		m_chkShiftShow;
	int			m_nShiftShowCheck;
	Button		m_chkAutoUpdate;
	int			m_nDlgID;
	
	//TreeEditControl		m_treeEditCntrl;
	ComboBox	m_comboTheme; //------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	Control		m_btnSaveTheme;
	Edit		m_editThemeDescription;
	
	Button		m_chkAdvanced; //--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	
	///DG SUPPORT_GETN_BOX_GRIDVIEW
	bool		m_bSetGridView;
	bool		m_bTranspose;
public:
	bool		Update(TreeNode& tr, bool bResize = true, bool bInit = false, bool bCallNodesHandlers = true);
	///end SUPPORT_GETN_BOX_GRIDVIEW
		 
	BOOL SetButtonText(int nButtonID, LPCSTR lpcszText);	////----- AW 10/02/06 QA80-9015 v8.0493 MORE_ON_ASCII_OPTION

	
private:
	//--- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	//bool		isShowAdvanced();
	bool		isShowAdvanced(TreeNode &tr = NULL);///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
	//---
public:
	//GetNBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, LPCSTR lpcszCurveNode) : TreeEditDlg(nID, "ODlg")	///DG SUPPORT_GETN_BOX_GRIDVIEW
	GetNBoxDlg(int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn, LPCSTR lpcszCurveNode, bool bSetGridView, bool bTranspose) : TreeEditDlg(nID, "ODlg")
	{
		m_input_tr = tr;//CPY 4/23/03 v7.0568 OPERATION_CLASS_NEED_TRY_AND_AUTO_UPDATE
		
		//----- CPY 6/11/04 GETN_SAVE_SETTINGS_ONLY_LOAD_DEFAULT_IF_NEW
		// the following will need to move to caller to decide if it should be done
		//	///Danice GETNTREE_AUTO_LOAD_DEFAULT
		//		tree_load_default_setting(tr);
		//	///END GETNTREE_AUTO_LOAD_DEFAULT
		//----- end GETN_SAVE_SETTINGS_ONLY_LOAD_DEFAULT_IF_NEW
		
		m_paramTree.AddNode(tr.Clone());
	
		m_pApplyFunc = pfn;
		m_pEventFunc = pEvtFn;
		m_bApply1stTime = true;
		
		m_strTitle = lpcszTitle;
		m_strDescription = lpcszDescription;
		
		m_strCuveNode = lpcszCurveNode;
		
		m_bUseTryForApply = false;
		m_bUseTryForApply = false;
		//---  CPY 5/22/03 v7.0589 SHIFT_SHOW_FOR_CLASSES
		tr.GetAttribute(STR_CLASS_NAME, m_strClassName);
		//---
		m_nDlgID = nID; 
		//m_bIsFlatDialogDisplay = IDD_GET_N_BOX == nID? true:false;
		
		///DG SUPPORT_GETN_BOX_GRIDVIEW
		m_bSetGridView=bSetGridView;
		m_bTranspose=bTranspose;
		///end SUPPORT_GETN_BOX_GRIDVIEW
	}
	
	void 	UpdateEditTreeNode(TreeNode& tr);
	int 	DoModalEx(HWND hWndParent = NULL);
	int 	CreateEx(HWND hWndParent = NULL);
	BOOL 	OnInitDialog();
	BOOL	OnReady();
	BOOL 	OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL 	OnDestroy(void);
	
	#if _OC_VER >= 0x0800
	BOOL	OnShowAdvancedCheck(Control ctrl); //---- CPY 12/23/04 QA70-7273 ADD_SHOW_ADVANCED_CHECK_BOX
	BOOL	OnSelectionChange();
	BOOL	OnSelectionTrack();
	
	/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
	BOOL	OnInteractiveDataRange(Control ctrl);
	BOOL	OnInteractiveXYDataRange(Control ctrl);
	BOOL	OnInteractivePopUp(Control ctrl);
	/// end VECTORIAL_NUMERIC_FUNCTIONS	
	
	BOOL 	OnComboChangeTheme(Control ctrl);
	BOOL	OnSaveTheme(Control ctrl);
	BOOL	OnSaveThemeAs(Control ctrl);
	#endif //if _OC_VER >= 0x0800

	BOOL 	OnApplyButton(Control cntrl);
	BOOL 	OnKey(BOOL bRollingUp);
	void 	OnAfterCollapse(Control cntrl, int nRow, short nState);
	BOOL 	OnReconstructGrid(UINT wParam, UINT lParam);
	void	OnComboCloseUp(Control cntrl, int nRow, int nCol, BOOL* pFinishEdit);	///DG FIT_SIZE_WHEN_LIST_CHANGED
	DECLARE_MESSAGE_MAP
protected:


private:
	//------ CPY 9/12/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG
	void 	trimThemeFileForDisplay(string& strFilename);
	bool 	loadThemeFilesToCombo(const TreeNode& trGUI);
	//----- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
	void	updateSaveButton(const string& strSelTheme);
	///Frank 1/26/05	GETN_DLG_ADVANCED_CHECK_SAVE
	//void	updateThemeDescription(TreeNode& trGUI, bool bEditToTree = true);
	string	updateThemeDescription(TreeNode& trGUI, bool bEditToTree = true);
	///End	GETN_DLG_ADVANCED_CHECK_SAVE
	//----
	int		getShiftShowStatus();
	void 	updateShiftShowStatus();
	bool 	shiftShow(bool bGet = true, bool bVal = false);
	void	saveDefaultGUI();
	bool 	isUseCurveRange();
	PEVENT_FUNC 	getEventHandler();
	PAPPLY_FUNC 	getApplyFunction();
	void 	enableButton(uint nBtnID, bool bEnable);
	void 	resizeDlgToFit();
	void 	resizeDialog(uint* pIntIDs);
	DWORD 	preCreateGetNBoxDlg(HWND hWndParent);

};
///End  MOVE_DECLARATION_TO_HEADER
#endif //#ifdef _OLD_GETN_BOX_CODE //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

#ifdef _OLD_GETN_MODELESS_DLG //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

//--------------- CPY 9/19/04 GETN_MODELESS_DLG
class GetNModelessDlg;
typedef GetNModelessDlg* GetNModelessDlgPtr;

class GetNModelessDlg : public GetNBoxDlg
{
public:
	GetNModelessDlg(GetNModelessDlgPtr* pDlgPtr, int nID, TreeNode& tr, LPCSTR lpcszTitle, LPCSTR lpcszDescription, PAPPLY_FUNC pfn, PEVENT_FUNC pEvtFn) :
		GetNBoxDlg(nID, tr, lpcszTitle, lpcszDescription, pfn, pEvtFn, NULL, true, false)
	{
		m_pThis = pDlgPtr;
	}

	void SetTree(const TreeNode& tr)
	{
		m_trGetN = tr;
	}
protected:
	//virtual
	BOOL OnDestroy(void)
	{
		GetNBoxDlg::OnDestroy();
		if(m_pThis)
			*m_pThis = NULL;
		return TRUE;
	}
		

private:
	Tree					m_trGetN;
	GetNModelessDlgPtr*		m_pThis;
};
#endif //#ifdef _OLD_GETN_MODELESS_DLG //---- CPY 10/14/06 MOVE_OPERATION_OUT_OF_SYS_FOLDER

//---- CPY 6/10/2008 REMOVE_GETN_NEXT_PREV_DLG
/*
/// SY 8/17/05 QA70-8027 v8.0290 IMPORT_WIZARD_XF
class GetNPrevNextDlg : public TreeEditDlg
{
public:
	GetNPrevNextDlg(TreeNode& tr, LPCSTR lpcszTitle, bool bSetGridView, bool bTranspose);
	~GetNPrevNextDlg();
	
	int DoModalEx(HWND hWndParent = NULL);
	int CreateEx(HWND hWndParent = NULL);
	
	void UpdateEditTreeNode(TreeNode& tr) {	tr = m_input_tr; }
	bool Update(TreeNode& tr, bool bResize = true, bool bInit = false, bool bCallNodesHandlers = true);
	
protected:
	DECLARE_MESSAGE_MAP
	BOOL OnInitDialog();
	BOOL OnDestroy();
	BOOL OnClickPrev(Control ctrl);
	BOOL OnClickNext(Control ctrl);
	void OnAfterCollapse(Control cntrl, int nRow, short nState);
	
private:
	void resizeDlgToFit();
	void resizeDialog(uint* pIntIDs);
	
	TreeNode 	m_input_tr;
	string		m_strTitle;

	Button		m_btnPrev;
	Button		m_btnNext;
	
	bool		m_bSetGridView;
	bool		m_bTranspose;
};
/// end IMPORT_WIZARD_XF
*/
//----- end CPY 6/10/2008 REMOVE_GETN_NEXT_PREV_DLG

#endif //_GETN_DLG_H
	
